<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\UpdateSetting */
class UpdateSettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'feed_url' => $this->feed_url,
            'current_version' => $this->current_version,
            'channel' => $this->channel,
            'is_active' => (bool) $this->is_active,
            'auto_check_enabled' => (bool) $this->auto_check_enabled,
            'check_interval_minutes' => (int) ($this->check_interval_minutes ?? 0),
            'request_timeout_seconds' => (int) ($this->request_timeout_seconds ?? 0),
            'verify_tls' => (bool) $this->verify_tls,
            'last_checked_at' => $this->last_checked_at,
            'last_remote_version' => $this->last_remote_version,
            'last_remote_build' => $this->last_remote_build,
            'last_error' => $this->last_error,
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}

