<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\TelephonyCall */
class TelephonyCallResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'external_id' => $this->external_id,
            'direction' => $this->direction,
            'from_number' => $this->from_number,
            'to_number' => $this->to_number,
            'status' => $this->status,
            'duration_seconds' => (int) $this->duration_seconds,
            'started_at' => $this->started_at,
            'ended_at' => $this->ended_at,
            'recording_url' => $this->recording_url,
            'user' => UserResource::make($this->whenLoaded('user')),
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
