<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class UpdateLastSeenAt
{
    /**
     * Handle an incoming request.
     *
     * @param  Closure(Request): Response  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if ($user === null) {
            return $next($request);
        }

        $now = now();
        $shouldUpdate = $user->last_seen_at === null || $user->last_seen_at->lt($now->copy()->subMinute());

        if ($shouldUpdate) {
            $user->forceFill([
                'last_seen_at' => $now,
            ])->saveQuietly();

            // Keep the in-request user instance in sync for current page render.
            $user->setAttribute('last_seen_at', $now);
        }

        return $next($request);
    }
}
