<?php

namespace Database\Factories;

use App\Models\Company;
use App\Models\Contact;
use App\Models\Deal;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Activity>
 */
class ActivityFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'type' => fake()->randomElement(['call', 'email', 'meeting', 'note', 'task_update']),
            'direction' => fake()->randomElement(['inbound', 'outbound', 'internal']),
            'subject' => fake()->sentence(4),
            'details' => fake()->optional()->paragraph(),
            'outcome' => fake()->optional()->randomElement(['Follow-up', 'No answer', 'Sent proposal', 'Successful']),
            'deal_id' => Deal::factory(),
            'company_id' => Company::factory(),
            'contact_id' => Contact::factory(),
            'user_id' => User::factory(),
            'occurred_at' => fake()->dateTimeBetween('-30 days', 'now'),
            'meta' => ['created_from' => 'factory'],
        ];
    }
}
