<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UpdateInstallation extends Model
{
    /** @use HasFactory<\Database\Factories\UpdateInstallationFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'update_setting_id',
        'update_check_id',
        'actor_id',
        'status',
        'target_version',
        'target_build',
        'package_url',
        'package_name',
        'package_path',
        'backup_path',
        'checksum_sha256',
        'message',
        'events',
        'started_at',
        'finished_at',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'update_setting_id' => 'integer',
            'update_check_id' => 'integer',
            'actor_id' => 'integer',
            'events' => 'array',
            'started_at' => 'datetime',
            'finished_at' => 'datetime',
        ];
    }

    public function setting(): BelongsTo
    {
        return $this->belongsTo(UpdateSetting::class, 'update_setting_id');
    }

    public function check(): BelongsTo
    {
        return $this->belongsTo(UpdateCheck::class, 'update_check_id');
    }

    public function actor(): BelongsTo
    {
        return $this->belongsTo(User::class, 'actor_id');
    }
}
