<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UpdateCheck extends Model
{
    /** @use HasFactory<\Database\Factories\UpdateCheckFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'update_setting_id',
        'status',
        'endpoint_url',
        'http_status',
        'is_update_available',
        'remote_version',
        'remote_build',
        'error_message',
        'payload',
        'checked_at',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'update_setting_id' => 'integer',
            'http_status' => 'integer',
            'is_update_available' => 'boolean',
            'payload' => 'array',
            'checked_at' => 'datetime',
        ];
    }

    public function setting(): BelongsTo
    {
        return $this->belongsTo(UpdateSetting::class, 'update_setting_id');
    }
}

