<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\HrSetting */
class HrSettingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'provider' => $this->provider,
            'is_active' => (bool) $this->is_active,
            'api_base_url' => $this->api_base_url,
            'api_key' => $this->api_key,
            'api_secret' => $this->api_secret,
            'webhook_secret' => $this->webhook_secret,
            'auto_assign_user_id' => $this->auto_assign_user_id,
            'auto_assign_user' => UserResource::make($this->whenLoaded('autoAssignUser')),
            'default_sla_days' => (int) ($this->default_sla_days ?? 0),
            'allow_employee_requests' => (bool) ($this->allow_employee_requests ?? false),
            'require_approval' => (bool) ($this->require_approval ?? false),
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
