<?php

namespace Tests\Feature;

use App\Models\Company;
use App\Models\Contact;
use App\Models\Deal;
use App\Models\DealStage;
use App\Models\Pipeline;
use App\Models\Task;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class SidebarEntityPanelTest extends TestCase
{
    use RefreshDatabase;

    public function test_task_show_can_be_rendered_in_sidebar_mode(): void
    {
        $user = User::factory()->create(['role' => 'admin']);
        $task = Task::factory()->create([
            'creator_id' => $user->id,
            'assignee_id' => $user->id,
        ]);

        $this->actingAs($user)
            ->get(route('tasks.show', $task).'?sidepanel=1')
            ->assertOk()
            ->assertSee('data-sidepanel-entity="task"', false)
            ->assertDontSee('<!DOCTYPE html>', false);
    }

    public function test_contact_show_can_be_rendered_in_sidebar_mode(): void
    {
        $user = User::factory()->create(['role' => 'admin']);
        $contact = Contact::factory()->create([
            'owner_id' => $user->id,
        ]);

        $this->actingAs($user)
            ->get(route('contacts.show', $contact).'?sidepanel=1')
            ->assertOk()
            ->assertSee('data-sidepanel-entity="contact"', false)
            ->assertDontSee('<!DOCTYPE html>', false);
    }

    public function test_deal_show_can_be_rendered_in_sidebar_mode(): void
    {
        $user = User::factory()->create(['role' => 'admin']);

        $pipeline = Pipeline::factory()->create();
        $stage = DealStage::factory()->create(['pipeline_id' => $pipeline->id]);
        $company = Company::factory()->create(['owner_id' => $user->id]);
        $contact = Contact::factory()->create([
            'company_id' => $company->id,
            'owner_id' => $user->id,
        ]);

        $deal = Deal::factory()->create([
            'pipeline_id' => $pipeline->id,
            'stage_id' => $stage->id,
            'company_id' => $company->id,
            'contact_id' => $contact->id,
            'owner_id' => $user->id,
            'status' => 'open',
        ]);

        $this->actingAs($user)
            ->get(route('deals.show', $deal).'?sidepanel=1')
            ->assertOk()
            ->assertSee('data-sidepanel-entity="deal"', false)
            ->assertDontSee('<!DOCTYPE html>', false);
    }
}
