<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class MessengerPageRenderTest extends TestCase
{
    use RefreshDatabase;

    public function test_messengers_index_renders_provider_filter_without_runtime_errors(): void
    {
        $admin = User::factory()->create([
            'role' => 'admin',
        ]);

        $this->actingAs($admin)
            ->get(route('messengers.index'))
            ->assertOk()
            ->assertSeeText('Messengers')
            ->assertSeeText('Telegram')
            ->assertSeeText('WhatsApp Business');
    }
}

