<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class MenuLocalizationTest extends TestCase
{
    use RefreshDatabase;

    public function test_sidebar_core_menu_is_translated_to_russian(): void
    {
        $user = User::factory()->create([
            'role' => 'admin',
            'locale' => 'ru',
        ]);

        $this->actingAs($user)
            ->get(route('dashboard'))
            ->assertOk()
            ->assertSee('Новости')
            ->assertSee('Статистика')
            ->assertSee('Компании')
            ->assertSee('Контакты')
            ->assertSee('Сделки')
            ->assertSee('Задачи');
    }
}

