<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;
use Tests\TestCase;

class HtmlLocalizationMiddlewareTest extends TestCase
{
    use RefreshDatabase;

    public function test_hardcoded_html_text_is_localized_for_russian_locale(): void
    {
        $path = '/__locale-middleware-test-'.Str::random(8);
        Route::middleware('web')->get($path, static function () {
            return response(
                '<html><body><h1>CRM panel</h1><input placeholder="Search by name, email, phone" /></body></html>',
                200,
                ['Content-Type' => 'text/html; charset=UTF-8']
            );
        });

        $user = User::factory()->create([
            'locale' => 'ru',
        ]);

        $response = $this->actingAs($user)->get($path);

        $response
            ->assertOk()
            ->assertSee('CRM-панель', false)
            ->assertSee('Поиск по имени, электронной почте, телефону', false)
            ->assertDontSee('CRM panel', false);
    }

    public function test_hardcoded_html_text_stays_original_for_english_locale(): void
    {
        $path = '/__locale-middleware-test-'.Str::random(8);
        Route::middleware('web')->get($path, static function () {
            return response(
                '<html><body><h1>CRM panel</h1><input placeholder="Search by name, email, phone" /></body></html>',
                200,
                ['Content-Type' => 'text/html; charset=UTF-8']
            );
        });

        $user = User::factory()->create([
            'locale' => 'en',
        ]);

        $response = $this->actingAs($user)->get($path);

        $response
            ->assertOk()
            ->assertSee('CRM panel', false)
            ->assertSee('Search by name, email, phone', false)
            ->assertDontSee('CRM-панель', false);
    }
}
