<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class HrFeatureTest extends TestCase
{
    use RefreshDatabase;

    public function test_admin_can_open_hr_section_and_create_request(): void
    {
        $admin = User::factory()->create([
            'role' => 'admin',
        ]);

        $this->actingAs($admin)
            ->get(route('hr.index'))
            ->assertOk()
            ->assertSee('HR Service')
            ->assertSee('HR requests');

        $this->actingAs($admin)
            ->post(route('hr.requests.store'), [
                'type' => 'vacation',
                'status' => 'new',
                'priority' => 'medium',
                'title' => 'Vacation request',
                'description' => 'Need 5 days off',
                'requested_date' => now()->toDateString(),
                'due_date' => now()->addDays(3)->toDateString(),
                'employee_user_id' => $admin->id,
                'assignee_user_id' => $admin->id,
                'creator_user_id' => $admin->id,
            ])
            ->assertRedirect(route('hr.index'));

        $this->assertDatabaseHas('hr_requests', [
            'title' => 'Vacation request',
            'type' => 'vacation',
            'status' => 'new',
            'priority' => 'medium',
            'employee_user_id' => $admin->id,
        ]);
    }

    public function test_regular_user_cannot_open_hr_section_by_default(): void
    {
        $user = User::factory()->create([
            'role' => 'user',
        ]);

        $this->actingAs($user)
            ->get(route('hr.index'))
            ->assertForbidden();
    }
}
