<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class DashboardLayoutRenderTest extends TestCase
{
    use RefreshDatabase;

    public function test_dashboard_sidebar_x_data_is_not_truncated_by_escaped_quotes(): void
    {
        $user = User::factory()->create(['role' => 'admin']);

        $response = $this->actingAs($user)->get(route('dashboard'));
        $response->assertOk();

        $html = $response->getContent();

        $this->assertStringNotContainsString('data-item-id=\\"', $html);
        $this->assertMatchesRegularExpression(
            '/<aside[^>]*x-data="[^"]*onMenuDragEnd\(event\)[^"]*"/s',
            $html
        );
    }

    public function test_dashboard_does_not_render_raw_sidebar_javascript_as_visible_text(): void
    {
        $user = User::factory()->create(['role' => 'admin']);

        $response = $this->actingAs($user)->get(route('dashboard'));
        $response->assertOk();

        $html = $response->getContent();
        $withoutScripts = preg_replace('/<script\b[^>]*>.*?<\/script>/is', '', $html) ?? $html;
        $visibleText = preg_replace('/\s+/u', ' ', trim(strip_tags($withoutScripts))) ?? '';

        $this->assertStringNotContainsString('onMenuDragStart(event)', $visibleText);
        $this->assertStringNotContainsString('saveMenuStructure();', $visibleText);
    }
}
