<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class AppearanceSettingsTest extends TestCase
{
    use RefreshDatabase;

    public function test_user_can_update_appearance_settings(): void
    {
        $user = User::factory()->create();

        $payload = [
            'start_page' => 'tasks',
            'palette' => [
                'primary' => '#123456',
                'background' => '#FFFFFF',
            ],
            'fonts' => [
                'body' => 'Figtree, ui-sans-serif',
                'heading' => 'Figtree, ui-sans-serif',
            ],
            'icons' => [
                'color' => '#334155',
            ],
        ];

        $this->actingAs($user)
            ->patch(route('profile.appearance.update'), $payload)
            ->assertRedirect(route('profile.edit', ['section' => 'appearance']));

        $user->refresh();

        $this->assertSame('tasks', $user->start_page);
        $this->assertSame('#123456', $user->appearance_settings['palette']['primary'] ?? null);
    }
}

