<?php

namespace Tests\Feature\Api;

use App\Models\Deal;
use App\Models\Pipeline;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class DealStageApiTest extends TestCase
{
    use RefreshDatabase;

    public function test_api_can_update_deal_stage_and_status(): void
    {
        $user = User::factory()->create([
            'role' => 'manager',
        ]);

        $pipeline = Pipeline::create([
            'name' => 'Sales',
            'description' => null,
            'is_default' => true,
            'is_active' => true,
            'sort_order' => 0,
        ]);

        $openStage = $pipeline->stages()->create([
            'name' => 'Qualification',
            'code' => 'qualification_1',
            'sort_order' => 0,
            'probability' => 40,
            'is_won' => false,
            'is_lost' => false,
        ]);

        $wonStage = $pipeline->stages()->create([
            'name' => 'Won',
            'code' => 'won_2',
            'sort_order' => 1,
            'probability' => 100,
            'is_won' => true,
            'is_lost' => false,
        ]);

        $deal = Deal::create([
            'title' => 'Big contract',
            'pipeline_id' => $pipeline->id,
            'stage_id' => $openStage->id,
            'owner_id' => $user->id,
            'amount' => 25000,
            'currency' => 'USD',
            'priority' => 'high',
            'status' => 'open',
            'source' => 'manual',
        ]);

        $token = $user->createToken('test-device')->plainTextToken;

        $response = $this->withHeader('Authorization', 'Bearer '.$token)
            ->patchJson('/api/v1/deals/'.$deal->id.'/stage', [
                'stage_id' => $wonStage->id,
            ]);

        $response
            ->assertOk()
            ->assertJsonPath('data.id', $deal->id)
            ->assertJsonPath('data.stage.id', $wonStage->id)
            ->assertJsonPath('data.status', 'won');

        $this->assertDatabaseHas('deals', [
            'id' => $deal->id,
            'stage_id' => $wonStage->id,
            'status' => 'won',
        ]);
    }
}
