@php
    $project = $project ?? null;
    $selectedMembersSet = collect(old('members', $selectedMembers ?? []))
        ->map(fn ($id) => (int) $id)
        ->all();
    $stagesValue = old('stages', $stagesInput ?? '');
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div class="md:col-span-2">
        <label for="name" class="block text-sm font-medium text-gray-700">Project name</label>
        <input id="name" name="name" type="text" required value="{{ old('name', $project?->name) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="code" class="block text-sm font-medium text-gray-700">Project code</label>
        <input id="code" name="code" type="text" maxlength="40" value="{{ old('code', $project?->code) }}" placeholder="AUTO" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 uppercase">
    </div>

    <div>
        <label for="visibility" class="block text-sm font-medium text-gray-700">Access</label>
        <select id="visibility" name="visibility" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (['team' => 'Team', 'private' => 'Private', 'public' => 'Public'] as $value => $label)
                <option value="{{ $value }}" @selected(old('visibility', $project?->visibility ?? 'team') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="company_id" class="block text-sm font-medium text-gray-700">Company</label>
        <select id="company_id" name="company_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            <option value="">Without company</option>
            @foreach ($companies as $company)
                <option value="{{ $company->id }}" @selected((int) old('company_id', $project?->company_id) === $company->id)>{{ $company->name }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="deal_id" class="block text-sm font-medium text-gray-700">Related transaction</label>
        <select id="deal_id" name="deal_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            <option value="">No deal</option>
            @foreach ($deals as $deal)
                <option value="{{ $deal->id }}" @selected((int) old('deal_id', $project?->deal_id) === $deal->id)>{{ $deal->title }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="owner_id" class="block text-sm font-medium text-gray-700">Owner</label>
        <x-user-search-select
            id="owner_id"
            name="owner_id"
            :users="$users"
            :selected="old('owner_id', $project?->owner_id)"
            placeholder="Search for owner"
            empty-label="Not assigned"
        />
    </div>

    <div>
        <label for="manager_id" class="block text-sm font-medium text-gray-700">Supervisor</label>
        <x-user-search-select
            id="manager_id"
            name="manager_id"
            :users="$users"
            :selected="old('manager_id', $project?->manager_id)"
            placeholder="Search for a leader"
            empty-label="Not assigned"
        />
    </div>

    <div>
        <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
        <select id="status" name="status" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (['planned' => 'Planned', 'active' => 'In work', 'on_hold' => 'Suspended', 'completed' => 'Completed', 'cancelled' => 'Canceled'] as $value => $label)
                <option value="{{ $value }}" @selected(old('status', $project?->status ?? 'planned') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="priority" class="block text-sm font-medium text-gray-700">Priority</label>
        <select id="priority" name="priority" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (['low' => 'Low', 'medium' => 'Medium', 'high' => 'High', 'critical' => 'Critical'] as $value => $label)
                <option value="{{ $value }}" @selected(old('priority', $project?->priority ?? 'medium') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="health" class="block text-sm font-medium text-gray-700">State</label>
        <select id="health" name="health" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (['normal' => 'Normal', 'warning' => 'Timing risk', 'risk' => 'Critical risk'] as $value => $label)
                <option value="{{ $value }}" @selected(old('health', $project?->health ?? 'normal') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="budget" class="block text-sm font-medium text-gray-700">Budget</label>
        <input id="budget" name="budget" type="number" min="0" step="0.01" value="{{ old('budget', $project?->budget ?? 0) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="spent" class="block text-sm font-medium text-gray-700">Cost fact</label>
        <input id="spent" name="spent" type="number" min="0" step="0.01" value="{{ old('spent', $project?->spent ?? 0) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="starts_at" class="block text-sm font-medium text-gray-700">Start</label>
        <input id="starts_at" name="starts_at" type="date" value="{{ old('starts_at', $project?->starts_at?->format('Y-m-d')) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="due_at" class="block text-sm font-medium text-gray-700">Deadline</label>
        <input id="due_at" name="due_at" type="date" value="{{ old('due_at', $project?->due_at?->format('Y-m-d')) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div class="md:col-span-2">
        <label for="members" class="block text-sm font-medium text-gray-700">Project team</label>
        <input
            id="members_search"
            type="text"
            placeholder="Search for a member"
            class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
        >
        <select id="members" name="members[]" multiple size="6" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach ($users as $user)
                <option value="{{ $user->id }}" @selected(in_array($user->id, $selectedMembersSet, true))>{{ $user->name }} ({{ $user->role }})</option>
            @endforeach
        </select>
        <p class="mt-1 text-xs text-gray-500">Hold Ctrl/Cmd to select multiple participants.</p>
    </div>
</div>

<div class="mt-4">
    <label for="description" class="block text-sm font-medium text-gray-700">Project Description</label>
    <textarea id="description" name="description" rows="4" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('description', $project?->description) }}</textarea>
</div>

<div class="mt-4">
    <label for="stages" class="block text-sm font-medium text-gray-700">Kanban stages (each stage on a new line)</label>
    <textarea id="stages" name="stages" rows="5" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ $stagesValue }}</textarea>
</div>

<div class="mt-4">
    <label for="notes" class="block text-sm font-medium text-gray-700">Internal notes</label>
    <textarea id="notes" name="notes" rows="3" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('notes', $project?->notes) }}</textarea>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const searchInput = document.getElementById('members_search');
        const membersSelect = document.getElementById('members');

        if (!searchInput || !membersSelect) {
            return;
        }

        const normalize = (value) => String(value || '').toLocaleLowerCase();

        searchInput.addEventListener('input', () => {
            const query = normalize(searchInput.value.trim());
            Array.from(membersSelect.options).forEach((option) => {
                const haystack = normalize(option.textContent);
                option.hidden = query !== '' && !haystack.includes(query);
            });
        });
    });
</script>
