<section class="space-y-6">
    <header>
        <h2 class="text-lg font-medium text-gray-900">
            {{ __('Two-factor authentication') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600">
            {{ __('Add an extra layer of security by requiring a verification code from your authenticator app during sign in.') }}
        </p>
    </header>

    @if ($user->hasTwoFactorEnabled())
        <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-800">
            {{ __('Two-factor authentication is enabled.') }}
        </div>
    @else
        <div class="rounded-lg border border-amber-200 bg-amber-50 px-4 py-3 text-sm text-amber-800">
            {{ __('Two-factor authentication is currently disabled.') }}
        </div>
    @endif

    @if ($twoFactorSetup)
        <div class="rounded-lg border border-gray-200 p-4">
            <p class="text-sm text-gray-700">
                {{ __('Scan this QR code with your authenticator app or enter the key manually.') }}
            </p>

            <div class="mt-4 flex flex-wrap items-start gap-6">
                <img
                    src="{{ $twoFactorSetup['qr_url'] }}"
                    alt="{{ __('QR code for two-factor setup') }}"
                    class="h-44 w-44 rounded-md border border-gray-200 bg-white p-2"
                >

                <div class="space-y-3">
                    <div>
                        <p class="text-xs font-semibold uppercase tracking-wide text-gray-500">{{ __('Manual setup key') }}</p>
                        <p class="mt-1 rounded-md bg-gray-100 px-3 py-2 font-mono text-sm text-gray-800">
                            {{ trim(chunk_split($twoFactorSetup['secret'], 4, ' ')) }}
                        </p>
                    </div>

                    <a
                        href="{{ $twoFactorSetup['otpauth'] }}"
                        class="inline-flex items-center rounded-md border border-gray-300 px-3 py-2 text-sm text-gray-700 hover:bg-gray-50"
                    >
                        {{ __('Open in authenticator app') }}
                    </a>
                </div>
            </div>

            <form method="POST" action="{{ route('profile.two-factor.confirm') }}" class="mt-6 max-w-sm space-y-4">
                @csrf

                <div>
                    <x-input-label for="two_factor_code" :value="__('Verification code')" />
                    <x-text-input
                        id="two_factor_code"
                        name="code"
                        type="text"
                        class="mt-1 block w-full"
                        inputmode="numeric"
                        autocomplete="one-time-code"
                        placeholder="123456"
                        :value="old('code')"
                        required
                    />
                    <x-input-error class="mt-2" :messages="$errors->get('code')" />
                </div>

                <x-primary-button>{{ __('Confirm and enable') }}</x-primary-button>
            </form>

            <div class="mt-6 rounded-md border border-gray-200 bg-gray-50 p-3">
                <p class="text-sm font-medium text-gray-900">{{ __('Recovery codes') }}</p>
                <p class="mt-1 text-xs text-gray-600">
                    {{ __('Save these recovery codes in a secure place. Each code can be used once.') }}
                </p>
                <div class="mt-3 grid grid-cols-2 gap-2">
                    @foreach ($twoFactorSetup['recovery_codes'] as $code)
                        <code class="rounded bg-white px-2 py-1 text-xs text-gray-800">{{ $code }}</code>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    @if (! $user->hasTwoFactorEnabled() && ! $twoFactorSetup)
        <form method="POST" action="{{ route('profile.two-factor.setup') }}">
            @csrf
            <x-primary-button>{{ __('Setup two-factor authentication') }}</x-primary-button>
        </form>
    @endif

    @if ($user->hasTwoFactorEnabled())
        <div class="rounded-lg border border-gray-200 p-4">
            <h3 class="text-sm font-semibold text-gray-900">{{ __('Recovery codes') }}</h3>
            <p class="mt-1 text-xs text-gray-600">
                {{ __('Save these recovery codes in a secure place. Each code can be used once.') }}
            </p>

            <div class="mt-3 grid grid-cols-2 gap-2">
                @foreach ((array) ($user->two_factor_recovery_codes ?? []) as $code)
                    <code class="rounded bg-gray-50 px-2 py-1 text-xs text-gray-800">{{ $code }}</code>
                @endforeach
            </div>

            <div class="mt-4 flex items-center gap-3">
                <form method="POST" action="{{ route('profile.two-factor.recovery-codes') }}">
                    @csrf
                    <x-secondary-button>{{ __('Regenerate recovery codes') }}</x-secondary-button>
                </form>

                <form method="POST" action="{{ route('profile.two-factor.disable') }}" onsubmit="return confirm('{{ __('Disable two-factor authentication?') }}')">
                    @csrf
                    @method('DELETE')
                    <x-danger-button>{{ __('Disable two-factor authentication') }}</x-danger-button>
                </form>
            </div>
        </div>
    @endif
</section>
