<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-3">
            <h2 class="text-xl font-semibold leading-tight text-gray-800">Edit form</h2>
            <a href="{{ route('forms.index') }}" class="text-sm font-medium text-indigo-600 hover:text-indigo-500">Back to forms</a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="w-full px-6 space-y-5">
            @if (session('success'))
                <div class="rounded-md border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-800">
                    {{ session('success') }}
                </div>
            @endif

            <section class="rounded-lg border border-slate-200 bg-white p-4 shadow-sm">
                <h3 class="text-sm font-semibold text-slate-900">Public link</h3>
                <a href="{{ route('public-forms.show', ['form' => $form->slug]) }}" target="_blank" rel="noopener" class="mt-1 inline-block break-all text-sm text-indigo-600 hover:text-indigo-500 hover:underline">
                    {{ route('public-forms.show', ['form' => $form->slug]) }}
                </a>
                <p class="mt-2 text-xs text-slate-500">Submissions: {{ (int) ($form->submissions_count ?? 0) }}</p>
            </section>

            @include('forms._form', [
                'action' => route('forms.update', $form),
                'httpMethod' => 'PATCH',
            ])

            <section class="rounded-lg border border-slate-200 bg-white p-4 shadow-sm">
                <h3 class="text-sm font-semibold text-slate-900">Recent submissions</h3>

                <div class="mt-3 overflow-auto">
                    <table class="min-w-full divide-y divide-slate-200">
                        <thead class="bg-slate-100">
                            <tr>
                                <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Date</th>
                                <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Status</th>
                                <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">Result</th>
                                <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">IP</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-100">
                            @forelse (($recentSubmissions ?? collect()) as $submission)
                                <tr>
                                    <td class="px-3 py-2 text-xs text-slate-700">{{ optional($submission->submitted_at)->format('Y-m-d H:i') }}</td>
                                    <td class="px-3 py-2 text-xs text-slate-700">{{ $submission->status }}</td>
                                    <td class="px-3 py-2 text-xs text-slate-700">{{ $submission->result_type ? $submission->result_type.' #'.$submission->result_id : '—' }}</td>
                                    <td class="px-3 py-2 text-xs text-slate-700">{{ $submission->ip_address ?: '—' }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-3 py-6 text-center text-xs text-slate-500">No submissions yet.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </section>
        </div>
    </div>
</x-app-layout>
