<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mail_service_settings', function (Blueprint $table): void {
            $table->id();
            $table->string('provider')->default('manual');
            $table->boolean('is_active')->default(false);
            $table->string('domain')->default('crm.local');
            $table->string('api_base_url')->nullable();
            $table->string('api_key')->nullable();
            $table->string('api_secret')->nullable();
            $table->string('account_id')->nullable();
            $table->string('webhook_secret')->nullable();
            $table->boolean('auto_provision_on_registration')->default(true);
            $table->boolean('auto_provision_on_user_create')->default(true);
            $table->string('default_status', 32)->default('active');
            $table->unsignedInteger('default_quota_mb')->default(2048);
            $table->json('meta')->nullable();
            $table->timestamps();

            $table->index('provider');
            $table->index('is_active');
            $table->index('domain');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mail_service_settings');
    }
};

