<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('telephony_settings', function (Blueprint $table): void {
            $table->id();
            $table->string('provider')->default('manual');
            $table->boolean('is_active')->default(false);
            $table->string('api_base_url')->nullable();
            $table->string('api_key')->nullable();
            $table->string('api_secret')->nullable();
            $table->string('account_id')->nullable();
            $table->string('inbound_number')->nullable();
            $table->string('outbound_number')->nullable();
            $table->string('webhook_secret')->nullable();
            $table->timestamps();

            $table->index('provider');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('telephony_settings');
    }
};
