<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('web_forms', function (Blueprint $table): void {
            if (! Schema::hasColumn('web_forms', 'style_settings')) {
                $table->json('style_settings')->nullable()->after('fields');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('web_forms', function (Blueprint $table): void {
            if (Schema::hasColumn('web_forms', 'style_settings')) {
                $table->dropColumn('style_settings');
            }
        });
    }
};
