<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('organization_companies', function (Blueprint $table): void {
            $table->foreignId('parent_id')
                ->nullable()
                ->after('sort_order')
                ->constrained('organization_companies')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('organization_companies', function (Blueprint $table): void {
            $table->dropConstrainedForeignId('parent_id');
        });
    }
};

