<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasTable('users')) {
            return;
        }

        Schema::table('users', function (Blueprint $table): void {
            if (! Schema::hasColumn('users', 'preferred_task_view')) {
                $table->string('preferred_task_view', 20)->default('list')->after('sidebar_collapsed');
            }

            if (! Schema::hasColumn('users', 'preferred_deal_view')) {
                $table->string('preferred_deal_view', 20)->default('list')->after('preferred_task_view');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (! Schema::hasTable('users')) {
            return;
        }

        Schema::table('users', function (Blueprint $table): void {
            if (Schema::hasColumn('users', 'preferred_deal_view')) {
                $table->dropColumn('preferred_deal_view');
            }

            if (Schema::hasColumn('users', 'preferred_task_view')) {
                $table->dropColumn('preferred_task_view');
            }
        });
    }
};
