<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    protected $model = Product::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->words(3, true),
            'sku' => strtoupper(fake()->bothify('SKU-####??')),
            'price' => fake()->randomFloat(2, 1, 10000),
            'currency' => 'USD',
            'unit' => fake()->randomElement(['pcs', 'license', 'hour']),
            'stock' => fake()->randomFloat(3, 0, 500),
            'status' => fake()->randomElement(['active', 'archived']),
            'company_id' => null,
            'owner_id' => User::factory(),
            'description' => fake()->optional()->sentence(),
        ];
    }
}
