<?php

namespace App\Support;

class UserStartPage
{
    /**
     * @return array<string, string>
     */
    public static function options(): array
    {
        return [
            'dashboard' => __('Dashboard'),
            'news' => __('News'),
            'tasks' => __('Tasks'),
            'deals' => __('Deals'),
            'companies' => __('Companies'),
            'contacts' => __('Contacts'),
            'projects' => __('Projects'),
            'calendar' => __('Calendar'),
            'disks' => __('Disk'),
            'products' => __('Products'),
            'warehouses' => __('Warehouses'),
            'forms' => __('Forms'),
            'pipelines' => __('Funnels'),
            'reports' => __('Reports'),
        ];
    }

    /**
     * @return array<string, string>
     */
    public static function routeMap(): array
    {
        return [
            'dashboard' => 'dashboard',
            'news' => 'news.index',
            'tasks' => 'tasks.index',
            'deals' => 'deals.index',
            'companies' => 'companies.index',
            'contacts' => 'contacts.index',
            'projects' => 'projects.index',
            'calendar' => 'calendar.index',
            'disks' => 'disks.index',
            'products' => 'products.index',
            'warehouses' => 'warehouses.index',
            'forms' => 'forms.index',
            'pipelines' => 'pipelines.index',
            'reports' => 'reports.index',
        ];
    }

    public static function resolveRouteName(?string $startPage): ?string
    {
        $key = trim((string) $startPage);
        if ($key === '') {
            return null;
        }

        $map = self::routeMap();

        return $map[$key] ?? null;
    }
}

