<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Warehouse;
use App\Support\AccessControl;

class WarehousePolicy
{
    public function viewAny(User $user): bool
    {
        return AccessControl::allows($user, 'warehouses', 'read');
    }

    public function view(User $user, Warehouse $warehouse): bool
    {
        return AccessControl::allows($user, 'warehouses', 'read');
    }

    public function create(User $user): bool
    {
        return AccessControl::allows($user, 'warehouses', 'create');
    }

    public function update(User $user, Warehouse $warehouse): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'warehouses', 'update');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'warehouses', 'update')) {
            return false;
        }

        return AccessControl::isElevated($user) || $warehouse->manager_id === $user->id;
    }

    public function delete(User $user, Warehouse $warehouse): bool
    {
        $decision = AccessControl::overridePermissionState($user, 'warehouses', 'delete');
        if ($decision !== null) {
            return $decision;
        }

        if (! AccessControl::roleAllows($user, 'warehouses', 'delete')) {
            return false;
        }

        return AccessControl::isElevated($user);
    }
}

